﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using System.Diagnostics;
using System.Data.Linq;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class DoDDeploymentImporter : MilitaryInfoServiceClient, IDeploymentImporter, IDisposable
    {
           
        public List<IDeployment> GetRegistrantDeployments(RegistrantHistory history, string edipi, DeploymentAbstractFactory factory)
        {
            var deployments = new List<IDeployment>();
            if (history == null)
                throw new ArgumentNullException(nameof(history));
            //Get deployments from eMis
            eMISdeploymentResponseType deploymentResponse = GetDeployments(edipi);
            if (deploymentResponse != null)
            {
                //the array of deployments are from emis and may be null
                if (deploymentResponse.deployment != null)
                {
                    deployments = factory.CreateDeployments(deploymentResponse, history);
                }
            }
            return deployments;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="edipi"></param>
        /// <param name="ssn"></param>
        /// <returns></returns>
        public BprDoDDeploymentImports GetDoDDeploymentImports(string edipi, string ssn)
        {
            REGISTRANT registrant = new AHOBPRRegistrantManager().GetRegistrantById(edipi, ssn);
            return new BprDeploymentManager().GetBprDoDDeploymentImports(registrant);
        }

        /// <summary>
        /// Overloaded method.Use the inputEdiPiOrIcn and InputHeaderInfo to create a getDeploymentRequest 
        /// </summary>
        /// <param name="edipi"></param>
        /// <param name="headerInfo"></param>
        /// <returns></returns>
        public eMISdeploymentResponseType GetDeployments(inputEdiPiOrIcn edipi, InputHeaderInfo headerInfo)
        {
            eMISdeploymentResponseType deployments = null;
            try
            {
                deployments = _client.getDeployment(ref headerInfo, edipi);
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Exception: DoDDeploymentImporter.GetDeployments  " + ex.Message + "\n" + ex.StackTrace);
                AHOBPRLogger.LogErrorMessage("Exception", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return deployments;
        }

        /// <summary>
        /// Overloaded method. Use this if you don't want to populate an InputHeaderInfo class
        /// </summary>
        /// <param name="edipi"></param>
        /// <returns></returns>
        eMISdeploymentResponseType GetDeployments(inputEdiPiOrIcn edipi)
        {
            return GetDeployments(edipi, new InputHeaderInfo());
        }

        /// <summary>
        /// Just have a edipi string? Start here. It'll create the parameters needed to create a getDeploymentRequest
        /// </summary>
        /// <param name="edipi"></param>
        /// <returns></returns>
        eMISdeploymentResponseType GetDeployments(string edipi)
        {
            //Because the client calls were generated and make not that much sense
            //we need to create an InputEdipiIcn which is used to create an inputEdiPiOrIcn
            //which can then be used to create a getDeploymentRequest in GetDeployments
            var inputEdipiIcn = InputEdipiOrIcnCreator.Create(edipi) ;
            return GetDeployments(inputEdipiIcn);
        }

      

        #region IDisposable Support
        private bool disposedValue; // To detect redundant calls

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    // TODO: dispose managed state (managed objects).
                }

                // TODO: free unmanaged resources (unmanaged objects) and override a finalizer below.
                // TODO: set large fields to null.

                disposedValue = true;
            }
        }

        // This code added to correctly implement the disposable pattern.
        public void Dispose()
        {
            // Do not change this code. Put cleanup code in Dispose(bool disposing) above.
            Dispose(true);
            // TODO: uncomment the following line if the finalizer is overridden above.
            // GC.SuppressFinalize(this);
        }
        #endregion

    }


}
